/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

import jp.mosp.kintai.dto.CmRotationDto;

public class ScheduleRotationCardVo extends ScheduleMenuVo {

	private static final long serialVersionUID = -6565156858919918031L;

	//URLACSS
	private static final String RETURN_URL	= "/jsp/kintai/scheduleRotationCard.jsp";
	private static final String EXTRA_JS		= "/pub/kintai/js/scheduleRotationCard.js";
	private static final String EXTRA_CSS		= "/pub/kintai/css/scheduleRotationCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_SCHEDULE_ROTATION_MASTER;

	//萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;

	// p[^
	public static final String PRM_TXT_RT_CODE		= "txtRtCode";
	public static final String PRM_TXT_RT_NAME		= "txtRtName";
	public static final String PRM_PLT_HOLIDAY		= "pltHoliday";
	public static final String PRM_PLT_DAY1			= "pltDay1";
	public static final String PRM_PLT_DAY2			= "pltDay2";
	public static final String PRM_PLT_DAY3			= "pltDay3";
	public static final String PRM_PLT_DAY4			= "pltDay4";
	public static final String PRM_PLT_DAY5			= "pltDay5";
	public static final String PRM_PLT_DAY6			= "pltDay6";
	public static final String PRM_PLT_DAY7			= "pltDay7";
	public static final String PRM_PLT_DAY8			= "pltDay8";
	public static final String PRM_PLT_DAY9			= "pltDay9";
	public static final String PRM_PLT_DAY10			= "pltDay10";
	public static final String PRM_PLT_DELETE			= "pltDelete";	

	// tB[h
	private String 	txtRTCode;
	private String 	txtRTName;
	private String 	pltHoliday;
	private String 	pltDay1;
	private String 	pltDay2;
	private String 	pltDay3;
	private String 	pltDay4;
	private String 	pltDay5;
	private String 	pltDay6;
	private String 	pltDay7;
	private String 	pltDay8;
	private String 	pltDay9;
	private String 	pltDay10;
	private String 	pltDelete;

	//v_EXg
	public String[][] aryPltWorkType;
	public String[][] aryPltHoliday;


	//[h(0FVKo^A1FXV)
	private int mode;	

	// tB[hyѐ
	public static final String NAM_RT_CODE    	= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_RT_NAME    	= CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_HOLIDAY   		= CommonConst.NAM_PUBLIC_HOLIDAY;
	public static final String NAM_DAY1  			= CommonConst.NAM_DAY1;
	public static final String NAM_DAY2 			= CommonConst.NAM_DAY2;
	public static final String NAM_DAY3    		= CommonConst.NAM_DAY3;
	public static final String NAM_DAY4    		= CommonConst.NAM_DAY4;
	public static final String NAM_DAY5   		= CommonConst.NAM_DAY5;
	public static final String NAM_DAY6  			= CommonConst.NAM_DAY6;
	public static final String NAM_DAY7 			= CommonConst.NAM_DAY7;
	public static final String NAM_DAY8    		= CommonConst.NAM_DAY8;
	public static final String NAM_DAY9    		= CommonConst.NAM_DAY9;
	public static final String NAM_DAY10   		= CommonConst.NAM_DAY10;
	public static final String NAM_DELETE			= CommonConst.NAM_DELETE_FLAG;

	public static final int	LEN_RT_CODE 	= 10;
	public static final int	LEN_RT_NAME		= 25;

	/**
	 * RXgN^
	 */
	public ScheduleRotationCardVo() {
		super();
		mode = 0;
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtRTCode("");
		setTxtRTName("");
		setPltHoliday("0");
		setPltDay1("");
		setPltDay2("");
		setPltDay3("");
		setPltDay4("");
		setPltDay5("");
		setPltDay6("");
		setPltDay7("");
		setPltDay8("");
		setPltDay9("");
		setPltDay10("");
		setPltDelete("0");		
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtRTCode	= request.getParameter(PRM_TXT_RT_CODE);
		txtRTName   = request.getParameter(PRM_TXT_RT_NAME);
		pltHoliday	= request.getParameter(PRM_PLT_HOLIDAY);
		pltDay1		= request.getParameter(PRM_PLT_DAY1);
		pltDay2		= request.getParameter(PRM_PLT_DAY2);
		pltDay3		= request.getParameter(PRM_PLT_DAY3);
		pltDay4		= request.getParameter(PRM_PLT_DAY4);
		pltDay5		= request.getParameter(PRM_PLT_DAY5);
		pltDay6		= request.getParameter(PRM_PLT_DAY6);
		pltDay7		= request.getParameter(PRM_PLT_DAY7);
		pltDay8		= request.getParameter(PRM_PLT_DAY8);
		pltDay9		= request.getParameter(PRM_PLT_DAY9);
		pltDay10	= request.getParameter(PRM_PLT_DAY10);
		pltDelete	= request.getParameter(PRM_PLT_DELETE);	
	}

	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(CmRotationDto dto){
		txtRTCode	= dto.getRtCode();
		txtRTName	= dto.getRtName();
		pltHoliday  = String.valueOf(dto.getHolidayFlag());
		pltDay1		= dto.getDay1();
		pltDay2		= dto.getDay2();
		pltDay3		= dto.getDay3();
		pltDay4		= dto.getDay4();
		pltDay5		= dto.getDay5();
		pltDay6		= dto.getDay6();
		pltDay7		= dto.getDay7();
		pltDay8		= dto.getDay8();
		pltDay9		= dto.getDay9();
		pltDay10	= dto.getDay10();
		pltDelete	= String.valueOf(dto.getDeleteFlag());		
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmRotationDto dto) {
		dto.setRtCode(txtRTCode);
		dto.setRtName(txtRTName);
		dto.setHolidayFlag(Integer.parseInt(pltHoliday));
		dto.setDay1(pltDay1);
		dto.setDay2(pltDay2);
		dto.setDay3(pltDay3);
		dto.setDay4(pltDay4);
		dto.setDay5(pltDay5);
		dto.setDay6(pltDay6);
		dto.setDay7(pltDay7);
		dto.setDay8(pltDay8);
		dto.setDay9(pltDay9);
		dto.setDay10(pltDay10);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	//ÓmFJn
	public void validate() throws MospException {
		startValidation();
		// K{mF
		checkRequired(txtRTCode, NAM_RT_CODE, PRM_TXT_RT_CODE);
		checkRequired(txtRTName, NAM_RT_NAME, PRM_TXT_RT_NAME);
		//^CvmF
		checkCode(txtRTCode, NAM_RT_CODE, PRM_TXT_RT_CODE);
		//񒷊mF		
		checkLength(txtRTCode, LEN_RT_CODE, NAM_RT_CODE	, PRM_TXT_RT_CODE);
		checkLength(txtRTName, LEN_RT_NAME, NAM_RT_NAME	, PRM_TXT_RT_NAME);
		//ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public void setTxtRTCode	(String txtRTCode	)		{ this.txtRTCode	= txtRTCode;	}
	public void setTxtRTName	(String txtRTName	)	 	{ this.txtRTName 	= txtRTName;	}
	public void setPltHoliday	(String pltHoliday	)		{ this.pltHoliday	= pltHoliday;	}
	public void setPltDay1		(String txtDay1		)	 	{ this.pltDay1 		= txtDay1;		}
	public void setPltDay2		(String txtDay2		)	 	{ this.pltDay2 		= txtDay2; 		}
	public void setPltDay3		(String txtDay3		)	 	{ this.pltDay3 		= txtDay3; 		}
	public void setPltDay4		(String txtDay4		)	 	{ this.pltDay4 		= txtDay4; 		}
	public void setPltDay5		(String txtDay5		)	 	{ this.pltDay5		= txtDay5; 		}
	public void setPltDay6		(String txtDay6		)	 	{ this.pltDay6 		= txtDay6; 		}
	public void setPltDay7		(String txtDay7		)	 	{ this.pltDay7 		= txtDay7; 		}
	public void setPltDay8		(String txtDay8		)	 	{ this.pltDay8 		= txtDay8; 		}
	public void setPltDay9		(String txtDay9		)	 	{ this.pltDay9 		= txtDay9; 		}
	public void setPltDay10	(String txtDay10	)	 	{ this.pltDay10		= txtDay10; 	}	
	public void setPltDelete	(String PltDelete	) 		{ this.pltDelete 	= PltDelete; 	}	

	public String getTxtRTCode     	() { return txtRTCode; 	}
	public String getTxtRTName     	() { return txtRTName; 	}
	public String getPltHoliday		() { return pltHoliday;	}
	public String getPltDay1		() { return pltDay1; 	}
	public String getPltDay2		() { return pltDay2; 	}
	public String getPltDay3		() { return pltDay3; 	}
	public String getPltDay4		() { return pltDay4; 	}
	public String getPltDay5		() { return pltDay5; 	}
	public String getPltDay6		() { return pltDay6; 	}
	public String getPltDay7		() { return pltDay7; 	}
	public String getPltDay8		() { return pltDay8; 	}
	public String getPltDay9		() { return pltDay9; 	}	
	public String getPltDay10		() { return pltDay10; 	}
	public String getPltDelete  	() { return pltDelete; 	}	

	public String getEscTxtRTCode	() { return escapeHTML(txtRTCode);	}
	public String getEscTxtRTName	() { return escapeHTML(txtRTName); 	}
	public String getEscPltHoliday	() { return escapeHTML(pltHoliday);	}
	public String getEscPltDay1		() { return escapeHTML(pltDay1); 	}
	public String getEscPltDay2		() { return escapeHTML(pltDay2); 	}
	public String getEscPltDay3		() { return escapeHTML(pltDay3); 	}
	public String getEscPltDay4		() { return escapeHTML(pltDay4); 	}
	public String getEscPltDay5		() { return escapeHTML(pltDay5); 	}
	public String getEscPltDay6		() { return escapeHTML(pltDay6); 	}
	public String getEscPltDay7		() { return escapeHTML(pltDay7); 	}
	public String getEscPltDay8		() { return escapeHTML(pltDay8); 	}
	public String getEscPltDay9		() { return escapeHTML(pltDay9); 	}
	public String getEscPltDay10	() { return escapeHTML(pltDay10); 	}	

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
